﻿using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;


namespace mtweb
{

/////////////////////////////////////////////////////////////////////

public partial class DControl : System.Web.UI.UserControl
{
  // Fields
  protected HistoryEventArgs m_hea = null;
  protected ParameterCollection m_pc = null;


  // Static ctor
  public static T LoadUC<T>(string file, Page p) where T : DControl
  {
    T dc = (T)p.LoadControl(file);
    dc.ID = Path.GetFileName(file).Replace('.', '_');
    dc.UCPage = file;
    return dc;
  }


  ///////////////////////////////////////////////
  // Properties

  public string UCPage
  {
    set {
      if (string.IsNullOrEmpty(value)) return;
      ViewState["UCPage"] = value;
    }
    get {
      string s = ViewState["UCPage"] as string;
      if (string.IsNullOrEmpty(s)) return null;
      return s;
    }
  }


  public ParameterCollection Params
  {
    get {
      string s = ViewState["Params"] as string;
      if (string.IsNullOrEmpty(s)) return null;
      return Util.DeserializePC(s);
    }

    set {
      if (value == null) ViewState.Remove("Params");
      else {
        m_pc = value;
        ViewState["Params"] = Util.SerializePC(value);
      }
    }
  }


  public HistoryEventArgs UCHistoryArgs
  {
    set { m_hea = value; }
    get { return m_hea; }
  }


  ///////////////////////////////////////////////
  // Methods

  public DControl LoadContent(string file, HistoryEventArgs e)
  {
    return null;
  }

  public DControl ReloadContent()
  {
    return null;
  }


}  // class
}  // namespace
